<?php
declare(strict_types=1);

$slug = tenant_slug();
$csrf = csrf_token();

$company = $company ?? [];
$ok  = $ok  ?? null;
$err = $err ?? null;

$logo = (string)($company['logo_path'] ?? '');
?>
<div class="flex items-center justify-between gap-3">
  <div>
    <h2 class="text-lg font-semibold">Firma Profili</h2>
    <p class="mt-1 text-sm text-slate-500 dark:text-slate-400">
      Logo, iletişim ve vergi bilgileri. (Panel/site ayarları için <a class="underline" href="<?= e(base_path('/'.$slug.'/settings')) ?>">Ayarlar</a>.)
    </p>
  </div>
</div>

<?php if (!empty($ok)): ?>
  <div class="mt-4 rounded-xl border border-emerald-200 bg-emerald-50 px-3 py-2 text-sm text-emerald-900 dark:border-emerald-900/40 dark:bg-emerald-950/30 dark:text-emerald-100">
    <?= e($ok) ?>
  </div>
<?php endif; ?>

<?php if (!empty($err)): ?>
  <div class="mt-4 rounded-xl border border-red-200 bg-red-50 px-3 py-2 text-sm text-red-900 dark:border-red-900/40 dark:bg-red-950/30 dark:text-red-100">
    <?= e($err) ?>
  </div>
<?php endif; ?>

<form class="mt-6 grid grid-cols-1 gap-4 lg:grid-cols-3"
      method="post"
      action="<?= e(base_path('/'.$slug.'/company')) ?>"
      enctype="multipart/form-data">
  <input type="hidden" name="csrf" value="<?= e($csrf) ?>">

  <!-- Left: Logo -->
  <div class="rounded-2xl border border-slate-200 p-5 dark:border-slate-800">
    <div class="text-sm font-semibold">Logo</div>

    <div class="mt-4 flex items-center gap-4">
      <div class="h-20 w-20 rounded-2xl border border-slate-200 bg-white p-2 dark:border-slate-800 dark:bg-slate-950/40">
        <?php if ($logo): ?>
          <img src="<?= e(base_path('/'.$logo)) ?>" alt="Logo" class="h-full w-full object-contain">
        <?php else: ?>
          <div class="h-full w-full flex items-center justify-center text-xs text-slate-400">Logo yok</div>
        <?php endif; ?>
      </div>
      <div class="flex-1">
        <label class="text-sm font-medium">Logo yükle (png/jpg/webp)</label>
        <input type="file" name="logo"
               accept="image/png,image/jpeg,image/webp"
               class="mt-2 block w-full text-sm file:mr-3 file:rounded-xl file:border-0 file:bg-slate-900 file:px-4 file:py-2 file:text-white dark:file:bg-white dark:file:text-slate-900">
        <p class="mt-2 text-xs text-slate-500 dark:text-slate-400">Öneri: Şeffaf PNG, max 2MB.</p>
      </div>
    </div>

    <div class="mt-4">
      <label class="text-sm font-medium">Logoyu kaldır</label>
      <div class="mt-2 flex items-center gap-2">
        <input id="remove_logo" type="checkbox" name="remove_logo" value="1"
               class="h-4 w-4 rounded border-slate-300">
        <label for="remove_logo" class="text-sm text-slate-600 dark:text-slate-300">
          Kaydedince mevcut logo silinsin
        </label>
      </div>
    </div>
  </div>

  <!-- Right: Company fields -->
  <div class="lg:col-span-2 rounded-2xl border border-slate-200 p-5 dark:border-slate-800">
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
      <div class="md:col-span-2">
        <label class="text-sm font-medium">Firma Adı</label>
        <input name="name" required
               value="<?= e((string)($company['name'] ?? '')) ?>"
               class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40"
               placeholder="Eren Gıda">
      </div>

      <div class="md:col-span-2">
        <label class="text-sm font-medium">Adres</label>
        <textarea name="address" rows="3"
                  class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40"
                  placeholder="Adres..."><?= e((string)($company['address'] ?? '')) ?></textarea>
      </div>

      <div>
        <label class="text-sm font-medium">Vergi Dairesi</label>
        <input name="tax_office"
               value="<?= e((string)($company['tax_office'] ?? '')) ?>"
               class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40">
      </div>

      <div>
        <label class="text-sm font-medium">Vergi No</label>
        <input name="tax_no"
               value="<?= e((string)($company['tax_no'] ?? '')) ?>"
               class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40">
      </div>

      <div>
        <label class="text-sm font-medium">Telefon</label>
        <input name="phone"
               value="<?= e((string)($company['phone'] ?? '')) ?>"
               class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40">
      </div>

      <div>
        <label class="text-sm font-medium">E-posta</label>
        <input name="email" type="email"
               value="<?= e((string)($company['email'] ?? '')) ?>"
               class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40">
      </div>

      <div>
        <label class="text-sm font-medium">Website</label>
        <input name="website"
               value="<?= e((string)($company['website'] ?? '')) ?>"
               class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40"
               placeholder="https://...">
      </div>

      <div>
        <label class="text-sm font-medium">IBAN</label>
        <input name="iban"
               value="<?= e((string)($company['iban'] ?? '')) ?>"
               class="mt-2 w-full rounded-xl border border-slate-200 bg-white px-3 py-2 text-sm dark:border-slate-800 dark:bg-slate-950/40"
               placeholder="TR..">
      </div>
    </div>

    <div class="mt-6 flex items-center justify-end gap-2">
      <button type="submit"
              class="rounded-xl bg-slate-900 px-4 py-2 text-sm text-white dark:bg-white dark:text-slate-900">
        Kaydet
      </button>
    </div>
  </div>
</form>
